/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.swt.animation;

import intrinsic.Function;
import intrinsic.mx.effects.*;

import org.eclipse.swt.*;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.*;

public class PropertyAnimation extends Animation {
	long duration;
	Object target, from, to;
	String property;
	AnimateProperty xAnin, yAnin, widthAnin, heightAnin;

void create() {
	if (target == null || property == null) SWT.error(SWT.ERROR_INVALID_ARGUMENT);
	Function easingFunction = easingFunction();
	if (property.equals("size") || property.equals("location") || property.equals("bounds")) {
		Parallel parallel = new Parallel ();
		if (parallel == null) SWT.error(SWT.ERROR_NO_HANDLES);
		object = parallel;
		if (property.equals("bounds") || property.equals("location")) {
			xAnin = new AnimateProperty();
			if (xAnin == null) SWT.error(SWT.ERROR_NO_HANDLES);
			xAnin.property = "x";
			xAnin.easingFunction = easingFunction;
			parallel.addChild(xAnin);
			yAnin = new AnimateProperty();
			if (yAnin == null) SWT.error(SWT.ERROR_NO_HANDLES);
			yAnin.property = "y";
			yAnin.easingFunction = easingFunction;
			parallel.addChild(yAnin);
		}
		if (property.equals("bounds") || property.equals("size")) {
			widthAnin = new AnimateProperty();
			if (widthAnin == null) SWT.error(SWT.ERROR_NO_HANDLES);
			widthAnin.property = "width";
			widthAnin.easingFunction = easingFunction;
			parallel.addChild(widthAnin);
			heightAnin = new AnimateProperty();
			if (heightAnin == null) SWT.error(SWT.ERROR_NO_HANDLES);
			heightAnin.property = "height";
			heightAnin.easingFunction = easingFunction;
			parallel.addChild(heightAnin);
		}
	} else {
		AnimateProperty animation = new AnimateProperty();
		if (animation == null) SWT.error(SWT.ERROR_NO_HANDLES);
		animation.property = property;
		animation.easingFunction = easingFunction;
		object = animation;
	}
	object.target = ((Control)target).object;
	object.duration = duration;
	if (property.equals("bounds")) {
		if (from != null) {
			Rectangle fromRect = (Rectangle)from;
			xAnin.fromValue = fromRect.x;
			yAnin.fromValue = fromRect.y;
			widthAnin.fromValue = fromRect.width;
			heightAnin.fromValue = fromRect.height;
		}
		Rectangle toRect = (Rectangle)to;
		xAnin.toValue = toRect.x;
		yAnin.toValue = toRect.y;
		widthAnin.toValue = toRect.width;
		heightAnin.toValue = toRect.height;
	} else if (property.equals("size")) {
		if (from != null) {
			Point fromPt = (Point)from;
			widthAnin.fromValue = fromPt.x;
			heightAnin.fromValue = fromPt.y;
		}
		Point toRect = (Point)to;
		widthAnin.toValue = toRect.x;
		heightAnin.toValue = toRect.y;
	} else if (property.equals("location")) {
		if (from != null) {
			Point fromPt = (Point)from;
			xAnin.fromValue = fromPt.x;
			yAnin.fromValue = fromPt.y;
		}
		Point toRect = (Point)to;
		xAnin.toValue = toRect.x;
		yAnin.toValue = toRect.y;
	} else if (property.equals("alpha")) {
		if (from != null) {
			int alphaFrom = ((Integer)from).intValue();
			((AnimateProperty)object).fromValue = (alphaFrom&0xFF) / (double)0xFF;
		}
		int alphaTo = ((Integer)to).intValue();
		((AnimateProperty)object).toValue = (alphaTo&0xFF) / (double)0xFF;
	} else {
		double fromVal = 0, toVal = 1;
		if (to instanceof Double) {
			if (from != null) fromVal = ((Double)from).doubleValue();
			toVal = ((Double)to).doubleValue();
		} else if (to instanceof Integer) {
			if (from != null) fromVal = ((Integer)from).doubleValue();
			toVal = ((Integer)to).doubleValue();
		}
		if (from != null) {
			((AnimateProperty)object).fromValue = fromVal;
		}
		((AnimateProperty)object).toValue = toVal;
	}
}

native Function easingFunction ()/*{
	import mx.effects.easing.*;
	return mx.effects.easing.Linear.easeNone;
}*/;

public long getDuration() {
	checkAnimation ();
	return duration;
}

public void setDuration(long duration) {
	checkAnimation ();
	this.duration = duration;
}

public void setFrom(Object value) {
	checkAnimation ();
	from = value;
}

public void setProperty(String property) {
	checkAnimation ();
	this.property = property;
}

public void setTarget(Object target) {
	checkAnimation ();
	this.target = target;
}

public void setTo(Object value) {
	checkAnimation ();
	to = value;
}

}

